/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;

public class CollectSyncStatusVisitor
extends RefreshLocalVisitor {
    protected MultiStatus status;
    protected List affectedResources;

    public CollectSyncStatusVisitor(String multiStatusTitle, IProgressMonitor monitor) {
        super(monitor);
        this.status = new MultiStatus("org.eclipse.core.resources", 1, multiStatusTitle, null);
        this.affectedResources = new ArrayList(20);
    }

    protected void changed(Resource target) {
        String message = Policy.bind("localstore.resourceIsOutOfSync", target.getFullPath().toString());
        this.status.add(new ResourceStatus(274, target.getFullPath(), message));
        this.affectedResources.add(target);
        this.resourceChanged = true;
    }

    public List getAffectedResources() {
        return this.affectedResources;
    }

    public MultiStatus getSyncStatus() {
        return this.status;
    }

    protected void refresh(Container parent) throws CoreException {
        this.changed(parent);
    }

    protected void createResource(UnifiedTreeNode node, Resource target) throws CoreException {
        this.changed(target);
    }

    protected void deleteResource(UnifiedTreeNode node, Resource target) throws CoreException {
        this.changed(target);
    }

    protected void fileToFolder(UnifiedTreeNode node, Resource target) throws CoreException {
        this.changed(target);
    }

    protected void folderToFile(UnifiedTreeNode node, Resource target) throws CoreException {
        this.changed(target);
    }

    protected void resourceChanged(UnifiedTreeNode node, Resource target) throws CoreException {
        this.changed(target);
    }
}

