/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionProperties;
import com.mysql.jdbc.ConnectionPropertiesTransform;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class NonRegisteringDriver
implements Driver {
    public static final String DBNAME_PROPERTY_KEY = "DBNAME";
    public static final boolean DEBUG = false;
    public static final int HOST_NAME_INDEX = 0;
    public static final String HOST_PROPERTY_KEY = "HOST";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final int PORT_NUMBER_INDEX = 1;
    public static final String PORT_PROPERTY_KEY = "PORT";
    public static final String PROPERTIES_TRANSFORM_KEY = "propertiesTransform";
    public static final boolean TRACE = false;
    public static final String USE_CONFIG_PROPERTY_KEY = "useConfigs";
    public static final String USER_PROPERTY_KEY = "user";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    static int getMajorVersionInternal() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = NonRegisteringDriver.safeIntParse("5");
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    static int getMinorVersionInternal() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = NonRegisteringDriver.safeIntParse("0");
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String[] parseHostPortPair(String string) throws SQLException {
        String hostPortPair;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int portIndex = hostPortPair.indexOf(":");
        String[] splitValues = new String[2];
        String hostname = null;
        if (portIndex != -1) {
            if (portIndex + 1 >= hostPortPair.length()) throw SQLError.createSQLException(Messages.getString("NonRegisteringDriver.37"), "01S00");
            String portAsString = hostPortPair.substring(portIndex + 1);
            splitValues[0] = hostname = hostPortPair.substring(0, portIndex);
            splitValues[1] = portAsString;
        } else {
            splitValues[0] = hostPortPair;
            splitValues[1] = null;
        }
        String[] stringArray = splitValues;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(stringArray, joinPoint);
        return splitValues;
    }

    private static int safeIntParse(String string) {
        int n;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            String intAsString;
            n = Integer.parseInt(intAsString);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptsURL(String string) throws SQLException {
        void url;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.parseURL((String)url, null) != null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        Connection connection;
        void info;
        void url;
        String string2 = string;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Properties props = null;
        props = this.parseURL((String)url, (Properties)info);
        if (props == null) {
            connection = null;
        } else {
            try {
                Connection newConn;
                connection = newConn = new Connection(this.host(props), this.port(props), props, this.database(props), (String)url);
            }
            catch (SQLException sqlEx) {
                throw sqlEx;
            }
            catch (Exception ex) {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("NonRegisteringDriver.17")) + ex.toString() + Messages.getString("NonRegisteringDriver.18"), "08001");
            }
        }
        Connection connection2 = connection;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection2, joinPoint);
        return connection;
    }

    /*
     * WARNING - void declaration
     */
    public String database(Properties properties) {
        void props;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = props.getProperty(DBNAME_PROPERTY_KEY);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public int getMajorVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = NonRegisteringDriver.getMajorVersionInternal();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public int getMinorVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = NonRegisteringDriver.getMinorVersionInternal();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        void url;
        Properties info;
        String string2 = string;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith("jdbc:mysql://")) {
            info = this.parseURL((String)url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY));
        hostProp.required = true;
        hostProp.description = Messages.getString("NonRegisteringDriver.3");
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, "3306"));
        portProp.required = false;
        portProp.description = Messages.getString("NonRegisteringDriver.7");
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_PROPERTY_KEY, info.getProperty(USER_PROPERTY_KEY));
        userProp.required = true;
        userProp.description = Messages.getString("NonRegisteringDriver.13");
        DriverPropertyInfo passwordProp = new DriverPropertyInfo(PASSWORD_PROPERTY_KEY, info.getProperty(PASSWORD_PROPERTY_KEY));
        passwordProp.required = true;
        passwordProp.description = Messages.getString("NonRegisteringDriver.16");
        DriverPropertyInfo[] dpi = ConnectionProperties.exposeAsDriverPropertyInfo(info, 5);
        dpi[0] = hostProp;
        dpi[1] = portProp;
        dpi[2] = dbProp;
        dpi[3] = userProp;
        dpi[4] = passwordProp;
        DriverPropertyInfo[] driverPropertyInfoArray = dpi;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(driverPropertyInfoArray, joinPoint);
        return dpi;
    }

    /*
     * WARNING - void declaration
     */
    public String host(Properties properties) {
        void props;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = props.getProperty(HOST_PROPERTY_KEY, "localhost");
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public boolean jdbcCompliant() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = false;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseURL(String string, Properties properties) throws SQLException {
        Properties properties2;
        String url;
        void defaults;
        Properties urlProps;
        String string2 = string;
        Properties properties3 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2, (Object)properties3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Properties properties4 = urlProps = defaults != null ? new Properties((Properties)defaults) : new Properties();
        if (url == null) {
            properties2 = null;
        } else if (!StringUtils.startsWithIgnoreCase(url, "jdbc:mysql://") && !StringUtils.startsWithIgnoreCase(url, "jdbc:mysql:mxj://")) {
            properties2 = null;
        } else {
            String propertiesTransformClassName;
            int index;
            int beginningOfSlashes = 13;
            if (StringUtils.startsWithIgnoreCase(url, "jdbc:mysql:mxj://")) {
                beginningOfSlashes = 17;
                urlProps.setProperty("socketFactory", "com.mysql.management.driverlaunched.ServerLauncherSocketFactory");
            }
            if ((index = url.indexOf("?")) != -1) {
                String paramString = url.substring(index + 1, url.length());
                url = url.substring(0, index);
                StringTokenizer queryParams = new StringTokenizer(paramString, "&");
                while (queryParams.hasMoreTokens()) {
                    String parameterValuePair = queryParams.nextToken();
                    int indexOfEquals = StringUtils.indexOfIgnoreCase(0, parameterValuePair, "=");
                    String parameter = null;
                    String value = null;
                    if (indexOfEquals != -1) {
                        parameter = parameterValuePair.substring(0, indexOfEquals);
                        if (indexOfEquals + 1 < parameterValuePair.length()) {
                            value = parameterValuePair.substring(indexOfEquals + 1);
                        }
                    }
                    if (value == null || value.length() <= 0 || parameter == null || parameter.length() <= 0) continue;
                    try {
                        urlProps.put(parameter, URLDecoder.decode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        urlProps.put(parameter, URLDecoder.decode(value));
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        urlProps.put(parameter, URLDecoder.decode(value));
                    }
                }
            }
            url = url.substring(beginningOfSlashes);
            String hostStuff = null;
            int slashIndex = url.indexOf("/");
            if (slashIndex != -1) {
                hostStuff = url.substring(0, slashIndex);
                if (slashIndex + 1 < url.length()) {
                    urlProps.put(DBNAME_PROPERTY_KEY, url.substring(slashIndex + 1, url.length()));
                }
            } else {
                hostStuff = url;
            }
            if (hostStuff != null && hostStuff.length() > 0) {
                urlProps.put(HOST_PROPERTY_KEY, hostStuff);
            }
            if ((propertiesTransformClassName = urlProps.getProperty(PROPERTIES_TRANSFORM_KEY)) != null) {
                try {
                    ConnectionPropertiesTransform propTransformer = (ConnectionPropertiesTransform)Class.forName(propertiesTransformClassName).newInstance();
                    urlProps = propTransformer.transformProperties(urlProps);
                }
                catch (InstantiationException e) {
                    throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + e.toString(), "01S00");
                }
                catch (IllegalAccessException e) {
                    throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + e.toString(), "01S00");
                }
                catch (ClassNotFoundException e) {
                    throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + e.toString(), "01S00");
                }
            }
            String configNames = null;
            if (defaults != null) {
                configNames = defaults.getProperty(USE_CONFIG_PROPERTY_KEY);
            }
            if (configNames == null) {
                configNames = urlProps.getProperty(USE_CONFIG_PROPERTY_KEY);
            }
            if (configNames != null) {
                List splitNames = StringUtils.split(configNames, ",", true);
                Properties configProps = new Properties();
                Iterator namesIter = splitNames.iterator();
                while (namesIter.hasNext()) {
                    String configName = (String)namesIter.next();
                    try {
                        InputStream configAsStream = this.getClass().getResourceAsStream("configs/" + configName + ".properties");
                        if (configAsStream == null) {
                            throw SQLError.createSQLException("Can't find configuration template named '" + configName + "'", "01S00");
                        }
                        configProps.load(configAsStream);
                    }
                    catch (IOException ioEx) {
                        throw SQLError.createSQLException("Unable to load configuration template '" + configName + "' due to underlying IOException: " + ioEx, "01S00");
                    }
                }
                Iterator<Object> propsIter = urlProps.keySet().iterator();
                while (propsIter.hasNext()) {
                    String key = propsIter.next().toString();
                    String property = urlProps.getProperty(key);
                    configProps.setProperty(key, property);
                }
                urlProps = configProps;
            }
            if (defaults != null) {
                Iterator<Object> propsIter = defaults.keySet().iterator();
                while (propsIter.hasNext()) {
                    String key = propsIter.next().toString();
                    String property = defaults.getProperty(key);
                    urlProps.setProperty(key, property);
                }
            }
            properties2 = urlProps;
        }
        Properties properties5 = properties2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(properties5, joinPoint);
        return properties2;
    }

    /*
     * WARNING - void declaration
     */
    public int port(Properties properties) {
        void props;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = Integer.parseInt(props.getProperty(PORT_PROPERTY_KEY, "3306"));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public String property(String string, Properties properties) {
        void name;
        void props;
        String string2 = string;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = props.getProperty((String)name);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string3;
    }

    static {
        Factory factory = new Factory("NonRegisteringDriver.java", Class.forName("com.mysql.jdbc.NonRegisteringDriver"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-getMajorVersionInternal-com.mysql.jdbc.NonRegisteringDriver----int-"), 121);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-getMinorVersionInternal-com.mysql.jdbc.NonRegisteringDriver----int-"), 130);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-host-com.mysql.jdbc.NonRegisteringDriver-java.util.Properties:-props:--java.lang.String-"), 402);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-jdbcCompliant-com.mysql.jdbc.NonRegisteringDriver----boolean-"), 418);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-parseURL-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:java.util.Properties:-url:defaults:-java.sql.SQLException:-java.util.Properties-"), 423);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-port-com.mysql.jdbc.NonRegisteringDriver-java.util.Properties:-props:--int-"), 624);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-property-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:java.util.Properties:-name:props:--java.lang.String-"), 638);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("c-parseHostPortPair-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:-hostPortPair:-java.sql.SQLException:-[Ljava.lang.String;-"), 149);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-safeIntParse-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:-intAsString:--int-"), 178);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-acceptsURL-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:-url:-java.sql.SQLException:-boolean-"), 210);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:java.util.Properties:-url:info:-java.sql.SQLException:-java.sql.Connection-"), 259);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-database-com.mysql.jdbc.NonRegisteringDriver-java.util.Properties:-props:--java.lang.String-"), 292);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMajorVersion-com.mysql.jdbc.NonRegisteringDriver----int-"), 301);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMinorVersion-com.mysql.jdbc.NonRegisteringDriver----int-"), 310);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPropertyInfo-com.mysql.jdbc.NonRegisteringDriver-java.lang.String:java.util.Properties:-url:info:-java.sql.SQLException:-[Ljava.sql.DriverPropertyInfo;-"), 341);
    }
}

