/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class StandardSocketFactory
implements SocketFactory {
    protected String host = null;
    protected int port = 3306;
    protected Socket rawSocket = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    public Socket afterHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket connect(String string, int n, Properties properties) throws SocketException, IOException {
        boolean wantsLocalBind;
        void portNumber;
        void hostname;
        void props;
        String string2 = string;
        int n2 = n;
        Properties properties2 = properties;
        Object[] objectArray = new Object[]{string2, Conversions.intObject((int)n2), properties2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (props == null) throw new SocketException("Unable to create socket");
        this.host = hostname;
        this.port = portNumber;
        Method connectWithTimeoutMethod = null;
        Method socketBindMethod = null;
        Class<?> socketAddressClass = null;
        String localSocketHostname = props.getProperty("localSocketAddress");
        String connectTimeoutStr = props.getProperty("connectTimeout");
        int connectTimeout = 0;
        boolean wantsTimeout = connectTimeoutStr != null && connectTimeoutStr.length() > 0 && !connectTimeoutStr.equals("0");
        boolean bl = wantsLocalBind = localSocketHostname != null && localSocketHostname.length() > 0;
        if (wantsTimeout || wantsLocalBind) {
            if (connectTimeoutStr != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutStr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                }
            }
            try {
                socketAddressClass = Class.forName("java.net.SocketAddress");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.net.Socket");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                connectWithTimeoutMethod = clazz.getMethod("connect", socketAddressClass, Integer.TYPE);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.net.Socket");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                socketBindMethod = clazz2.getMethod("bind", socketAddressClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Throwable throwable) {}
            if (wantsLocalBind && socketBindMethod == null) {
                throw new SocketException("Can't specify \"localSocketAddress\" on JVMs older than 1.4");
            }
            if (wantsTimeout && connectWithTimeoutMethod == null) {
                throw new SocketException("Can't specify \"connectTimeout\" on JVMs older than 1.4");
            }
        }
        if (this.host == null) throw new SocketException("Unable to create socket");
        if (!wantsLocalBind && !wantsTimeout) {
            InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
            Exception caughtWhileConnecting = null;
            int i = 0;
            while (i < possibleAddresses.length) {
                try {
                    this.rawSocket = new Socket(possibleAddresses[i], this.port);
                    break;
                }
                catch (Exception ex) {
                    caughtWhileConnecting = ex;
                    ++i;
                }
            }
            if (this.rawSocket == null) {
                this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
            }
        } else {
            try {
                InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                Exception caughtWhileConnecting = null;
                Object localSockAddr = null;
                Class<?> inetSocketAddressClass = null;
                Constructor<?> addrConstructor = null;
                try {
                    inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.net.InetAddress");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    classArray[1] = Integer.TYPE;
                    addrConstructor = inetSocketAddressClass.getConstructor(classArray);
                    if (wantsLocalBind) {
                        localSockAddr = addrConstructor.newInstance(InetAddress.getByName(localSocketHostname), new Integer(0));
                    }
                }
                catch (Throwable ex) {
                    this.unwrapExceptionToProperClassAndThrowIt(ex);
                }
                int i = 0;
                while (i < possibleAddresses.length) {
                    try {
                        this.rawSocket = new Socket();
                        Object sockAddr = addrConstructor.newInstance(possibleAddresses[i], new Integer(this.port));
                        socketBindMethod.invoke((Object)this.rawSocket, localSockAddr);
                        connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                    }
                    catch (Exception ex) {
                        this.rawSocket = null;
                        caughtWhileConnecting = ex;
                    }
                    ++i;
                }
                if (this.rawSocket == null) {
                    this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                }
            }
            catch (Throwable t) {
                this.unwrapExceptionToProperClassAndThrowIt(t);
            }
        }
        try {
            this.rawSocket.setTcpNoDelay(true);
        }
        catch (Exception exception) {}
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    private void unwrapExceptionToProperClassAndThrowIt(Throwable throwable) throws SocketException, IOException {
        Throwable caughtWhileConnecting;
        Throwable throwable2 = throwable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)throwable2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (caughtWhileConnecting instanceof InvocationTargetException) {
            caughtWhileConnecting = ((InvocationTargetException)caughtWhileConnecting).getTargetException();
        }
        if (caughtWhileConnecting instanceof SocketException) {
            throw (SocketException)caughtWhileConnecting;
        }
        if (caughtWhileConnecting instanceof IOException) {
            throw (IOException)caughtWhileConnecting;
        }
        throw new SocketException(caughtWhileConnecting.toString());
    }

    static {
        Factory factory = new Factory("StandardSocketFactory.java", Class.forName("com.mysql.jdbc.StandardSocketFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-com.mysql.jdbc.StandardSocketFactory-java.lang.String:int:java.util.Properties:-hostname:portNumber:props:-java.net.SocketException:java.io.IOException:-java.net.Socket-"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-unwrapExceptionToProperClassAndThrowIt-com.mysql.jdbc.StandardSocketFactory-java.lang.Throwable:-caughtWhileConnecting:-java.net.SocketException:java.io.IOException:-void-"), 275);
    }
}

